/*
 * Decompiled with CFR 0.152.
 */
package com.sync.delta;

import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.DecoratedFrame;
import com.sync.delta.HistoryDataSeries;
import com.sync.delta.Printer;
import com.sync.delta.TrafficData;
import com.sync.delta.delta_closeButton_actionAdapter;
import com.sync.delta.delta_pauseButton_actionAdapter;
import com.sync.delta.delta_printButton_actionAdapter;
import com.sync.delta.delta_resetButton_actionAdapter;
import com.sync.syncman.pm.ProcMgr;
import com.sync.syncman.pm.SMEvent;
import com.sync.syncman.pm.SMListener;
import com.sync.syncman.pm.ShowDataEvent;
import com.sync.syncman.pm.ShowDataListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.JCChartComponent;

public class Delta
extends DecoratedFrame
implements ShowDataListener,
SMListener {
    BevelPanel bevelPanel1 = new BevelPanel();
    BevelPanel bevelPanel2 = new BevelPanel();
    BevelPanel buttonPanel = new BevelPanel();
    BevelPanel scrollPanel = new BevelPanel();
    BevelPanel chartPanel = new BevelPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    Button closeButton = new Button();
    Button printButton = new Button();
    Button resetButton = new Button();
    Button pauseButton = new Button();
    JCChartComponent jCChartComponent1 = new JCChartComponent();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    Scrollbar scrollbar1 = new Scrollbar();
    Label sampleLabel = new Label();
    static final int MIN_SIZE = 400;
    static final int MAX_VARS = 8;
    String[] myArgs;
    String unitName;
    String[] labels = new String[8];
    int key = 0;
    int variables = 0;
    int maxSamples = 0;
    int displaySamples = 0;
    int scrollPage = 0;
    boolean paused = false;
    boolean initd = false;
    TrafficData td;
    HistoryDataSeries hds;
    HistoryDataSeries snap;
    DateFormat gdf;
    static final Color[] chartColors = new Color[]{Color.blue, Color.red, Color.yellow, Color.black, Color.green, Color.cyan, Color.magenta, Color.white};

    public Delta(String[] args) {
        try {
            this.myArgs = args;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.unitName = this.myArgs[0];
        this.key = Integer.parseInt(this.myArgs[1]);
        ((Frame)((Object)this)).setTitle(this.myArgs[2]);
        this.variables = Integer.parseInt(this.myArgs[3]);
        this.maxSamples = Integer.parseInt(this.myArgs[4]);
        this.displaySamples = Integer.parseInt(this.myArgs[5]);
        for (int i = 0; i < this.variables; ++i) {
            this.labels[i] = this.myArgs[6 + i];
        }
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Component)((Object)this)).setSize(new Dimension(553, 329));
        this.bevelPanel1.setLayout(this.borderLayout3);
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.scrollPanel.setLayout(this.borderLayout4);
        this.chartPanel.setLayout(this.borderLayout5);
        this.flowLayout1.setHgap(8);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setVgap(6);
        this.closeButton.setLabel("Close");
        this.closeButton.addActionListener(new delta_closeButton_actionAdapter(this));
        this.printButton.setLabel(" Print ");
        this.printButton.addActionListener(new delta_printButton_actionAdapter(this));
        this.resetButton.setLabel("Reset");
        this.resetButton.addActionListener(new delta_resetButton_actionAdapter(this));
        this.pauseButton.setLabel("Pause");
        this.pauseButton.addActionListener(new delta_pauseButton_actionAdapter(this));
        this.jCChartComponent1.setX1AxisTitleText("Time ");
        this.jCChartComponent1.setX1AxisTitleIsShowing(true);
        this.jCChartComponent1.getLegend().setIsShowing(true);
        this.jCChartComponent1.getLegend().setAnchor(1);
        this.jCChartComponent1.getChartArea().getXAxis(0).setAnnotationMethod(2);
        this.buttonPanel.setLayout(this.flowLayout1);
        ((Container)((Object)this)).add((Component)this.bevelPanel1, "Center");
        this.bevelPanel1.add((Component)this.bevelPanel2, "Center");
        this.bevelPanel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.pauseButton, null);
        this.buttonPanel.add((Component)this.resetButton, null);
        this.buttonPanel.add((Component)this.printButton, null);
        this.buttonPanel.add((Component)this.closeButton, null);
        this.scrollbar1.setOrientation(0);
        this.scrollbar1.setSize(70, 20);
        this.scrollbar1.setBlockIncrement(16);
        this.scrollbar1.addAdjustmentListener(new 1());
        this.scrollPanel.add((Component)this.scrollbar1, "Center");
        this.scrollPanel.add((Component)this.sampleLabel, "West");
        this.bevelPanel2.add((Component)this.scrollPanel, "South");
        this.chartPanel.add((Component)this.jCChartComponent1, "Center");
        this.bevelPanel2.add((Component)this.chartPanel, "Center");
        this.scrollPanel.setMargins(new Insets(2, 2, 2, 2));
        this.scrollPanel.setVisible(false);
        this.hds = new HistoryDataSeries();
        this.hds.setSize(this.variables, this.maxSamples);
        this.gdf = DateFormat.getDateTimeInstance(1, 3);
        this.init_chart();
        ProcMgr.clientRegister((int)40, (String)this.unitName, (int)this.key, (int)-1);
        ProcMgr.addSMListener((SMListener)this);
        ProcMgr.addShowDataListener((ShowDataListener)this);
        ((Window)((Object)this)).addWindowListener(new 2());
    }

    public void showData(ShowDataEvent e) {
        if (this.initd) {
            double[] values = new double[this.variables];
            int[] data = e.getData();
            for (int i = 0; i < this.variables; ++i) {
                values[i] = data[i];
            }
            this.update_chart(values);
        }
    }

    void init_chart() {
        this.jCChartComponent1.setIsBatched(true);
        this.jCChartComponent1.getDataView(0).setDataSource((Chartable)new TrafficData(this.variables, this.maxSamples));
        ChartDataViewSeries[] cdvs = this.jCChartComponent1.getDataView(0).getSeries();
        for (int i = 0; i < this.variables; ++i) {
            cdvs[i].getStyle().setLineColor(chartColors[i]);
            cdvs[i].getStyle().setSymbolColor(chartColors[i]);
            cdvs[i].setLabel(this.labels[i]);
        }
        this.jCChartComponent1.setIsBatched(false);
        this.initd = true;
    }

    public synchronized void update_chart(double[] values) {
        this.hds.update(values);
        if (!this.paused) {
            if (this.hds.getSeriesSize() > this.displaySamples) {
                this.display_chart(this.hds, this.displaySamples, this.hds.getSeriesSize() - this.displaySamples);
            } else {
                this.display_chart(this.hds, this.hds.getSeriesSize(), 0);
            }
        }
    }

    public synchronized void display_chart(HistoryDataSeries thishds, int samples, int page) {
        this.jCChartComponent1.setIsBatched(true);
        this.td = new TrafficData(thishds, samples, page);
        this.jCChartComponent1.getDataView(0).setDataSource((Chartable)this.td);
        ChartDataViewSeries[] cdvs = this.jCChartComponent1.getDataView(0).getSeries();
        for (int i = 0; i < this.variables; ++i) {
            cdvs[i].setLabel(this.labels[i]);
        }
        this.jCChartComponent1.setIsBatched(false);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.exit();
    }

    synchronized void resetButton_actionPerformed(ActionEvent e) {
        this.hds.reset();
        this.init_chart();
    }

    synchronized void pauseButton_actionPerformed(ActionEvent e) {
        boolean bl = this.paused = !this.paused;
        if (this.paused) {
            if (this.hds.getSeriesSize() > this.displaySamples) {
                this.snap = (HistoryDataSeries)this.CreateCopy(this.hds);
                this.scrollbar1.setValues(this.snap.getSeriesSize() - this.displaySamples, this.displaySamples, 0, this.snap.getSeriesSize() - 1);
                this.sampleLabel.setText(String.valueOf(String.valueOf("    Number of Samples = ").concat(String.valueOf(this.snap.getSeriesSize()))).concat(String.valueOf("         ")));
                this.scrollPanel.setVisible(true);
                this.bevelPanel2.validate();
                ((Component)((Object)this)).repaint();
            }
            this.pauseButton.setLabel(" Start ");
        } else {
            this.scrollPanel.setVisible(false);
            this.bevelPanel2.validate();
            ((Component)((Object)this)).repaint();
            if (this.hds.getSeriesSize() > this.displaySamples) {
                this.display_chart(this.hds, this.displaySamples, this.hds.getSeriesSize() - this.displaySamples);
            } else {
                this.display_chart(this.hds, this.hds.getSeriesSize(), 0);
            }
            this.pauseButton.setLabel("Pause");
        }
    }

    void printButton_actionPerformed(ActionEvent e) {
        Printer printer = new Printer((Frame)((Object)this));
        printer.setFont(new Font("SansSerif", 1, 14));
        printer.println(((Frame)((Object)this)).getTitle());
        printer.println("");
        printer.setFont(new Font("SansSerif", 0, 12));
        Date rightnow = new Date(System.currentTimeMillis());
        printer.println(String.valueOf("  Produced on: ").concat(String.valueOf(this.gdf.format(rightnow))));
        printer.println("");
        printer.println("");
        printer.newPage((Container)this.chartPanel);
        printer.endJob();
    }

    private void exit() {
        ProcMgr.clientEnd();
        System.exit(0);
    }

    public void closeNow(SMEvent e) {
        this.exit();
    }

    public void pmActivate(SMEvent e) {
        ((Component)((Object)this)).setVisible(true);
        ((Window)((Object)this)).show();
        ((Window)((Object)this)).toFront();
    }

    private Object CreateCopy(Object object) {
        Object copy = null;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(object);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));
            copy = in.readObject();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        return copy;
    }

    final /* synthetic */ void access$071() {
        this.exit();
    }

    class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Delta.this.access$071();
        }

        2() {
        }
    }

    class 1
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            Delta.this.scrollPage = e.getValue();
            Delta.this.display_chart(Delta.this.snap, Delta.this.displaySamples, Delta.this.scrollPage);
        }

        1() {
        }
    }
}

